/*
 * Decompiled with CFR 0.152.
 */
package net.voidz.dimension;

import net.adventurez.entity.VoidShadowEntity;
import net.adventurez.init.EntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.voidz.access.ServerPlayerAccess;
import net.voidz.init.BlockInit;

public class VoidPlacementHandler {
    public static final BlockPos VOID_SPAWN_POS = new BlockPos(0, 100, 0);

    public static PortalInfo enter(ServerPlayer serverPlayerEntity, ServerLevel serverWorld, BlockPos portalPos) {
        ((ServerPlayerAccess)serverPlayerEntity).setVoidPortingBlockPos(serverPlayerEntity.m_20183_());
        VoidPlacementHandler.spawnVoidPlatform(serverWorld, VOID_SPAWN_POS.m_7495_());
        return new PortalInfo(Vec3.m_82528_((Vec3i)VOID_SPAWN_POS).m_82520_(0.5, 0.0, 0.5), Vec3.f_82478_, 0.0f, 0.0f);
    }

    public static PortalInfo leave(ServerPlayer serverPlayerEntity, ServerLevel serverWorld, BlockPos portalPos) {
        return new PortalInfo(Vec3.m_82528_((Vec3i)((ServerPlayerAccess)serverPlayerEntity).getVoidPortingBlockPos()).m_82520_(0.5, 0.0, 0.5), Vec3.f_82478_, serverWorld.m_213780_().m_188501_() * 360.0f, 0.0f);
    }

    private static void spawnVoidPlatform(ServerLevel world, BlockPos pos) {
        if (world.m_8055_(pos).m_60734_() != BlockInit.PORTAL) {
            BlockState platformBlock = BlockInit.VOID_STONE.m_49966_();
            float u = 0.0f;
            while ((double)u < Math.PI * 2) {
                for (int i = 0; i < 40; ++i) {
                    BlockPos blockPos = pos.m_7918_((int)(Math.sin(u) * (double)i), 0, (int)(Math.cos(u) * (double)i));
                    if (!world.m_8055_(blockPos).m_60795_()) continue;
                    world.m_46597_(blockPos, platformBlock);
                }
                u += 0.012271847f;
            }
            world.m_46597_(pos, BlockInit.PORTAL.m_49966_());
            VoidPlacementHandler.spawnVoidBoss(world, pos.m_7494_());
        }
    }

    public static void spawnVoidBoss(ServerLevel world, BlockPos spawnPos) {
        VoidShadowEntity voidShadowEntity = (VoidShadowEntity)EntityInit.VOID_SHADOW.m_20615_((Level)world);
        voidShadowEntity.setVoidMiddle(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
        voidShadowEntity.m_20035_(spawnPos.m_7494_().m_122013_(40), 0.0f, 0.0f);
        world.m_7967_((Entity)voidShadowEntity);
    }
}

